/****************************************************************************
 *   $Id:: power_profiles.c 25 2011-02-02 21:21:24Z nxp12832                $
 *   Project: NXP LPC11xx software example  
 *
 *   Description:
 *     Power API Header File for NXP LPC11Uxx Device Series 
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/

#include "power_profiles.h"

/*	Memory used by the Power Profiles driver */
static uint32_t command[4], result[3];
ROM **rom;

/*********************************************/



uint32_t config_pll_power(POWER_PROFILE *profile) {

	#ifdef LPC11xxL
		volatile uint32_t i;
	#endif /* LPC11xx */

	rom = (ROM **)0x1FFF1FF8;
/*	
 *	1: Call set_power API routine to switch to default mode @ 50MHz
 *	2: Switch MAINCLKSEL to sys_pllclkin with AHBCLKDIV = 1 (12Mhz)
 *	3: Call set_pll API routine for the new freq
 *	4: Call set_power to the desired power mode 
 */

	/****	Config set_power to default mode @ 50Mhz ****/
	command[0] = 50;
	command[1] = PARAM_DEFAULT;
	command[2] = profile->current_system_clock / 1000000;
	(*rom)->pPWRD->set_power(command, result);
	/****************************************************/

	/*	Add the required delay after using set_power */
	DELAY_SET_POWER;

	if(result[0])
		return result[0];

	/****	Required by the Power Profiles set_pll API ****/
	/*	Switch to the sys_pllclkin to the main clock */
	LPC_SYSCON->MAINCLKSEL = 0x1;
	LPC_SYSCON->MAINCLKUEN = 0x0;
	LPC_SYSCON->MAINCLKUEN = 0x1;
	/* Wait until updated */
	while ( !(LPC_SYSCON->MAINCLKUEN & 0x01) );
	
	/*	Specify AHBCLKDIV = 1 */
	LPC_SYSCON->SYSAHBCLKDIV = 1;
	/******************************************************/

	/****	Update the POWER_PROFILE struct with the new system free of SYS_PLLCLKIN_FREQ ****/
	profile->current_system_clock = SYS_PLLCLKIN_FREQ;

	/****	Call set_pll routine ****/
	command[0] = profile->current_system_clock / 1000;	//12000kHz from sys_pllclkin
	command[1] = profile->new_system_clock / 1000;		//New kHz freq
	command[2] = CPU_FREQ_APPROX;						//Use CPU_FREQ_APPROX
	command[3] = profile->new_system_clock / 1000000;	//Number of loop cycles to wait
	(*rom)->pPWRD->set_pll(command, result);			//Apply new freq.
	/********************************/

	if(result[0])
		return result[0];
	else
		/****	Update the current_clock var with the new main clock freq ****/
		profile->current_system_clock = result[1] * 1000;	//result[1] is in kHz

	/****	Call the set_power routine ****/
	command[0] = result[1] / 1000;						//Current freq in MHz
	command[1] = profile->power_mode;					//Use the designated power mode
	command[2] = 50;									//Change the set_power from previous 50MHz to new mode
	(*rom)->pPWRD->set_power(command, result);			//Apply new power mode
	/**************************************/

	if(result[0])
		return result[0];

	return 0; //SUCCESS
}
